<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat top center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        justify-content: center;
                        align-items: center;
                }

                .title {
                        font-size: 22px;
                        font-weight: 600;
                        color: #ff40a5;
                        margin-bottom: 10px;
                }

                .sub-title {
                        font-size: 18px;
                        font-weight: 400;
                        color: #666;
                        margin-bottom: 20px;
                }

                .wheel-container {
                        position: relative;
                        width: 280px;
                        height: 280px;
                        /* display: flex; */
                        justify-content: center;
                        align-items: center;
                        margin-left: 30px;
                }

                .wheel {
                        width: 100%;
                        height: 100%;
                        transition: transform 3s ease-out;
                }

                .pointer {
                        position: absolute;
                        top: 5px;
                        left: 50%;
                        transform: translateX(-50%);
                        width: 30px;
                        height: 50px;
                        z-index: 10;
                }

                .button {
                        padding: 12px 60px;
                        font-size: 16px;
                        font-weight: 600;
                        color: #fff;
                        border: none;
                        border-radius: 30px;
                        background: linear-gradient(90deg, #a735ff, #ff6b99);
                        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
                        cursor: pointer;
                        transition: all 0.3s ease;
                        margin-top: 30px;
                }

                .next-button {
                        padding: 12px 60px;
                        font-size: 16px;
                        font-weight: 600;
                        color: #fff;
                        border: none;
                        border-radius: 30px;
                        background: linear-gradient(90deg, #a735ff, #ff6b99);
                        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.2);
                        cursor: pointer;
                        transition: all 0.3s ease;
                        margin-top: 30px;
                        margin-left: 80px;
                }


                .button:hover,
                .next-button:hover {
                        opacity: 0.9;
                }

                .next-button {
                        display: none;
                }
        </style>
</head>

<body>
        <div class="container">
                <?php
                include('./ad_responsive.php');
                ?>
                <div class="title">Win Extra <b style="color: #6e1de8;">Free Minutes!</b></div>
                <div class="sub-title">Spin The Wheel</div>
                <div class="wheel-container">
                        <img src="./image/spinarrow.png" alt="Pointer Arrow" class="pointer">
                        <img src="./image/spinner.png" alt="Spin Wheel" class="wheel" id="wheel">
                </div>
                <button class="button" onclick="spinWheel()">🎡 Spin Now</button>
                <button class="next-button" id="nextButton" onclick="goToNext()">Go To Next</button>
                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>

        <script>
                function spinWheel() {
                        const wheel = document.getElementById('wheel');
                        const nextButton = document.getElementById('nextButton');
                        const randomSpin = Math.floor(Math.random() * 360) + 1800; // Ensure multiple full spins

                        wheel.style.transition = 'transform 3s ease-out';
                        wheel.style.transform = `rotate(${randomSpin}deg)`;

                        setTimeout(() => {
                                nextButton.style.display = 'block'; // Show Next button after spin completes
                        }, 3000);
                }

                function goToNext() {
                        window.location.href = './mood.php';
                }
        </script>
</body>

</html>