<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat center top;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        align-items: center;
                        justify-content: center;
                }

                h2 {
                        font-size: 20px;
                        font-weight: bold;
                        color: #444;
                        margin-bottom: 20px;
                }

                .emoji-grid {
                        display: grid;
                        grid-template-columns: repeat(3, 1fr);
                        gap: 15px;
                        margin-left: 20px;
                }

                .emoji-box {
                        width: 80px;
                        height: 80px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 15px;
                        background-color: #fff;
                        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
                        cursor: pointer;
                        transition: all 0.3s ease-in-out;
                }

                .emoji-box img {
                        width: 50px;
                        height: 50px;
                }

                .emoji-box.selected {
                        border: 2px solid #ff00ff;
                        box-shadow: 0 0 10px rgba(255, 0, 255, 0.5);
                }

                .next-btn {
                        display: none;
                        background: linear-gradient(to right, #a233ff, #ff7eb3);
                        border: none;
                        padding: 15px 20px;
                        color: white;
                        font-size: 16px;
                        font-weight: bold;
                        border-radius: 30px;
                        cursor: pointer;
                        width: 90%;
                        max-width: 300px;
                        transition: 0.3s;
                        margin-top: 20px;
                        margin-left: 20px;
                }

                .next-btn:hover {
                        opacity: 0.9;
                }

                .banner-ad {
                        position: fixed;
                        bottom: 0;
                        left: 0;
                        width: 100%;
                        background-color: #fff;
                        text-align: center;
                        padding: 5px;
                        box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
                        z-index: 1000;
                }
        </style>
</head>

<body>
        <div class="container">
                <h2>Choose Your Mood And Meet Your Moody Connection.</h2>
                <?php include('./ad_responsive.php'); ?>

                <div class="emoji-grid">
                        <?php
                        for ($i = 1; $i <= 9; $i++) {
                                echo "<div class='emoji-box' onclick='selectMood(this)'><img src='./image/emoji$i.png' alt='emoji'></div>";
                        }
                        ?>
                </div>

                <button class="next-btn" id="nextBtn" onclick="goToNextPage()">Next</button>

                <?php include('./ad_responsive2.php'); ?>

                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php include('./ad_ecpm_content.php'); ?>
                </p>

                <p style="margin-bottom: 150px;">
                        <?php include('./ad_content.php'); ?>
                </p>
        </div>

        <div class="banner-ad">
                <?php include('./ad_banner.php'); ?>
        </div>

        <script>
                function selectMood(element) {
                        document.querySelectorAll('.emoji-box').forEach(box => box.classList.remove('selected'));
                        element.classList.add('selected');
                        document.getElementById("nextBtn").style.display = "block";
                }

                function goToNextPage() {
                        window.location.href = "/share.php";
                }
        </script>
</body>

</html>