<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <style>
                /* Import Google Font */
                @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap');

                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat top center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                }

                /* Title Styling */
                .title {
                        font-size: 22px;
                        font-weight: 600;
                        color: #333;
                }

                .title span {
                        color: #ff3e96;
                        font-weight: bold;
                }

                /* Live Indicator */
                .live-banner {
                        display: inline-block;
                        background: linear-gradient(90deg, #ff3e96, #ff9068);
                        padding: 10px 15px;
                        font-size: 14px;
                        color: #fff;
                        font-weight: bold;
                        border-radius: 20px;
                        margin-top: 10px;
                }

                /* Grid of Images */
                .grid {
                        display: grid;
                        grid-template-columns: repeat(3, 1fr);
                        gap: 10px;
                        margin-top: 20px;
                }

                .profile {
                        position: relative;
                        width: 100%;
                        height: 100%;
                        border-radius: 10px;
                        overflow: hidden;
                        background: #f0f0f0;
                }

                .profile img {
                        width: 100%;
                        height: 170px;
                }

                /* Start Video Call Button */
                .start-btn {
                        width: 100%;
                        padding: 15px;
                        margin-top: 20px;
                        font-size: 16px;
                        font-weight: bold;
                        background: linear-gradient(to right, #8a2be2, #ff1493, #ff8c00);
                        color: #fff;
                        border: none;
                        border-radius: 30px;
                        cursor: pointer;
                        transition: 0.3s;
                }

                .start-btn:hover {
                        opacity: 0.9;
                }

                .main-profile img {
                        width: 100%;
                        height: 100%;
                        /* border-radius: 50%; */
                        object-fit: cover;
                        margin-top: 50px;
                }


                /* Responsive Mobile View */
                @media screen and (min-width: 768px) {
                        body {
                                width: 400px;
                                margin: auto;
                                padding: 0;
                        }
                }
        </style>
</head>

<body>
        <div class="container">
                <?php
                include('./ad_responsive.php');
                ?>
                <h2 class="title">Random Video Call</span></h2>
                <div class="live-banner">Live Available Now!</div>

                <!-- <div class="grid">
                        <div class="profile"><img src="./image/girl1.png" alt="Girl 1"></div>
                        <div class="profile"><img src="./image/girl2.png" alt="Girl 2"></div>
                        <div class="profile"><img src="./image/girl3.png" alt="Girl 3"></div>
                        <div class="profile"><img src="./image/girl4.png" alt="Girl 4"></div>
                        <div class="profile"><img src="./image/girl5.png" alt="Girl 5"></div>
                        <div class="profile"><img src="./image/girl6.png" alt="Girl 6"></div>
                </div> -->

                <div class="main-profile">
                        <img src="./image/start.png" alt="Main Profile">
                </div>

                <a href="./gender.php"><button class="start-btn">Start</button></a>
                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>
</body>

</html>