<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap"
                rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat top center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        justify-content: center;
                        align-items: center;
                }


                /* Title */
                .title {
                        font-size: 22px;
                        font-weight: 700;
                        color: #ff1493;
                        text-align: center;
                        margin-bottom: 20px;
                }

                /* Card Section */
                .card-container {
                        display: flex;
                        justify-content: space-between;
                        gap: 10px;
                        margin-bottom: 20px;
                }

                .card {
                        width: 48%;
                        background-color: #fff;
                        border-radius: 15px;
                        overflow: hidden;
                        position: relative;
                        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
                        cursor: pointer;
                        transition: border 0.3s;
                }

                .card img {
                        width: 100%;
                        border-radius: 15px;
                        display: block;
                }

                .feature-card.selected {
                        border: 3px solid #FB3BB4;
                        border-radius: 18px;
                }

                .badge {
                        position: absolute;
                        top: 10px;
                        right: 10px;
                        background: linear-gradient(to right, #C74DF5, #FB3BB4);
                        color: white;
                        font-size: 12px;
                        font-weight: 700;
                        padding: 5px 10px;
                        border-radius: 20px;
                }

                .badge img {
                        width: 16px;
                        height: 16px;
                        vertical-align: middle;
                        margin-right: 3px;
                }

                /* Card Text */
                .card-text {
                        position: absolute;
                        bottom: 20px;
                        left: 10px;
                        color: white;
                        text-align: left;
                }

                .card-text .title {
                        font-size: 14px;
                        font-weight: 600;
                        color: #ffcc99;
                        text-align: left;
                        margin-bottom: 0;
                }

                .card-text p {
                        font-size: 14px;
                        font-weight: 400;
                }

                /* Button */
                .btn {
                        display: none;
                        width: 100%;
                        max-width: 360px;
                        margin: 0 auto;
                        padding: 15px;
                        font-size: 16px;
                        font-weight: 600;
                        color: white;
                        background: linear-gradient(to right, #8a2be2, #ff1493, #ff8c00);
                        text-align: center;
                        border: none;
                        border-radius: 100px;
                        cursor: pointer;
                        transition: 0.3s;
                }

                .btn:hover {
                        opacity: 0.9;
                }

                a {
                        text-decoration: none;
                }

                @media screen and (min-width: 768px) {
                        body {
                                width: 400px;
                                margin: auto;
                                padding: 0;
                        }
                }

                .feature-card {
                        width: 50%;
                        padding: 20px;
                        border-radius: 12px;
                        border: 1px solid #ddd;
                        text-align: left;
                        display: flex;
                        flex-direction: column;
                        align-items: flex-start;
                        gap: 5px;
                        background: #fff;
                        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
                }

                /* Icons */
                .icon {
                        width: 80px;
                        height: 80px;
                }

                .feature-card h2 {
                        font-size: 18px;
                        font-weight: bold;
                        color: #6a1b9a;
                }

                .feature-card p {
                        font-size: 14px;
                        color: #888;
                }
        </style>
</head>

<body>

        <div class="container">
                <?php
                include('./ad_responsive.php');
                ?>
                <h2 class="title">Free Vs VIP</h2>

                <!-- Card Section -->
                <!-- <div class="card-container">
                        <div class="card" onclick="selectCard(this)">
                                <img src="./image/free.png" alt="Free Call">
                                <div class="badge">FREE</div>
                                <div class="card-text">
                                        <p class="title">Free:</p>
                                        <p>Limited To 30 Seconds</p>
                                </div>
                        </div>

                        <div class="card" onclick="selectCard(this)">
                                <img src="./image/vip.png" alt="VIP Call">
                                <div class="badge">👑</div>
                                <div class="card-text">
                                        <p class="title">VIP:</p>
                                        <p>Unlimited & Private Mode</p>
                                </div>
                        </div>
                </div> -->

                <div class="card-container">
                        <!-- Free Call Card -->
                        <div class="feature-card" onclick="selectCard(this)">
                                <img src="./image/freeicon.png" alt="Free Icon" class="icon">
                                <h2>Free:</h2>
                                <p>Limited To 30 Seconds</p>
                        </div>

                        <!-- VIP Call Card -->
                        <div class="feature-card" onclick="selectCard(this)">
                                <img src="./image/vipicon.png" alt="VIP Icon" class="icon">
                                <h2>VIP:</h2>
                                <p>Unlimited & Private Mode</p>
                        </div>
                </div>



                <!-- VIP Button -->
                <a href="./connectionissue.php"><button class="btn" id="unlockBtn">Unlock VIP (Recommended)</button></a>
                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>

        <script>
                function selectCard(card) {
                        document.querySelectorAll(".feature-card").forEach(c => c.classList.remove("selected"));
                        card.classList.add("selected");
                        document.getElementById("unlockBtn").style.display = "block";
                }
        </script>

</body>

</html>