<!DOCTYPE html>
<html lang="en">

<head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call - Select Server</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

        <style>
                /* General Styles */
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                /* Container */
                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                }

                /* Title */
                .title {
                        font-size: 28px;
                        font-weight: 600;
                        color: #ff66b2;
                        text-align: left;
                        margin-bottom: 15px;
                }

                .title span {
                        color: #8a2be2;
                }

                /* Server Grid */
                .server-container {
                        display: grid;
                        grid-template-columns: repeat(2, 1fr);
                        gap: 10px;
                        justify-content: center;
                        align-items: center;
                        max-width: 400px;
                        margin-top: 10px;
                }

                /* Server Box */
                .server-box {
                        width: 150px;
                        height: 150px;
                        border-radius: 20px;
                        text-align: center;
                        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
                        transition: transform 0.3s ease-in-out, border 0.3s ease-in-out;
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                        justify-content: center;
                        cursor: pointer;
                        border: 3px solid transparent;
                }

                .server-box:hover {
                        transform: translateY(-5px);
                }

                /* Highlight selected server */
                .server-box.selected {
                        border-color: #ff66b2;
                        box-shadow: 0 4px 20px rgba(255, 102, 178, 0.5);
                }

                .server-box img {
                        width: 100%;
                        height: 100%;
                        border-radius: 15px;
                }

                /* Next Button */
                .next-btn {
                        display: none;
                        margin-top: 20px;
                        padding: 10px 20px;
                        font-size: 18px;
                        font-weight: 600;
                        color: white;
                        background: #ff66b2;
                        border: none;
                        border-radius: 5px;
                        cursor: pointer;
                        transition: background 0.3s ease-in-out;
                }

                .next-btn:hover {
                        background: #e0559e;
                }

                /* Responsive Design */
                @media screen and (max-width: 768px) {
                        .server-container {
                                grid-template-columns: repeat(2, 1fr);
                        }
                }
        </style>
</head>

<body>

        <div class="container">
                <h1 class="title">Server <span>Room</span></h1>

                <div class="server-container">
                        <div class="server-box" onclick="selectServer(1)">
                                <img src="./image/server1.png" alt="Server 1">
                        </div>
                        <div class="server-box" onclick="selectServer(2)">
                                <img src="./image/server2.png" alt="Server 2">
                        </div>
                        <div class="server-box" onclick="selectServer(3)">
                                <img src="./image/server3.png" alt="Server 3">
                        </div>
                        <div class="server-box" onclick="selectServer(4)">
                                <img src="./image/server4.png" alt="Server 4">
                        </div>
                </div>

                <button class="next-btn" id="nextBtn" onclick="goToNextPage()">Next</button>
        </div>

        <script>
                let selectedServer = null;

                function selectServer(serverNumber) {
                        // Remove 'selected' class from all server boxes
                        document.querySelectorAll('.server-box').forEach(box => {
                                box.classList.remove('selected');
                        });

                        // Get the clicked server box and highlight it
                        let selectedBox = document.querySelectorAll('.server-box')[serverNumber - 1];
                        selectedBox.classList.add('selected');

                        // Update selected server
                        selectedServer = serverNumber;

                        // Show "Next" button
                        document.getElementById("nextBtn").style.display = "block";
                }

                function goToNextPage() {
                        if (selectedServer) {
                                alert("Server " + selectedServer + " selected. Proceeding...");
                                // Redirect or proceed to next functionality
                                window.location.href = "nextpage.html"; // Change to actual URL
                        }
                }
        </script>

</body>

</html>