<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat center top;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        align-items: center;
                        justify-content: center;
                }

                h1 {
                        font-size: 28px;
                        font-weight: 400;
                        color: #ff3399;
                        text-align: left;
                }

                h1 span {
                        font-weight: 600;
                        color: #a93af5;
                }

                .container {
                        width: 90%;
                        max-width: 400px;
                        margin-top: 10px;
                }

                .country-box {
                        display: flex;
                        align-items: center;
                        justify-content: space-between;
                        padding: 15px;
                        border: 2px solid #ccc;
                        border-radius: 15px;
                        margin-bottom: 10px;
                        cursor: pointer;
                        transition: 0.3s;
                        background-color: #fff;
                }

                .country-box img {
                        width: 40px;
                        height: 30px;
                        border-radius: 5px;
                }

                .country-box span {
                        flex: 1;
                        text-align: left;
                        font-size: 18px;
                        font-weight: 400;
                        margin-left: 10px;
                        color: #666;
                }

                .country-box .icon {
                        opacity: 0.3;
                }

                /* Active State */
                .selected {
                        background-color: #ffccf2;
                        border: 2px solid #ff3399;
                }

                .selected span {
                        color: #ff3399;
                        font-weight: 600;
                }

                .selected .icon {
                        opacity: 1;
                }

                .continue-btn {
                        width: 100%;
                        padding: 15px;
                        font-size: 20px;
                        font-weight: 600;
                        text-align: center;
                        color: #fff;
                        border-radius: 30px;
                        background: linear-gradient(to right, #a93af5, #ff3399, #ff9966);
                        border: none;
                        cursor: pointer;
                        margin-top: 20px;
                        transition: 0.3s;
                }

                .continue-btn:hover {
                        opacity: 0.9;
                }
        </style>
</head>

<body>



        <div class="container">
                <?php
                include('./ad_responsive.php');
                ?>
                <h1>Select <br><span>Your Country</span></h1>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag1.png" alt="UK Flag">
                        <span>United Kingdom</span>
                        <img class="icon" src="./image/country/country1.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag2.png" alt="Canada Flag">
                        <span>Canada</span>
                        <img class="icon" src="./image/country/country2.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag3.png" alt="India Flag">
                        <span>India</span>
                        <img class="icon" src="./image/country/country3.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag4.png" alt="Australia Flag">
                        <span>Australia</span>
                        <img class="icon" src="./image/country/country4.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag5.png" alt="Germany Flag">
                        <span>Germany</span>
                        <img class="icon" src="./image/country/country5.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag6.png" alt="Russia Flag">
                        <span>Russia</span>
                        <img class="icon" src="./image/country/country6.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag7.png" alt="South Africa Flag">
                        <span>South Africa</span>
                        <img class="icon" src="./image/country/country7.png" alt="Check Icon">
                </div>
                <div class="country-box" onclick="selectCountry(this)">
                        <img src="./image/country/flag8.png" alt="Indonesia Flag">
                        <span>Indonesia</span>
                        <img class="icon" src="./image/country/country7.png" alt="Check Icon">
                </div>

                <button class="continue-btn" onclick="continueSelection()">Continue</button>
                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>

        <script>
                function selectCountry(selectedBox) {
                        let allBoxes = document.querySelectorAll('.country-box');
                        allBoxes.forEach(box => box.classList.remove('selected'));
                        selectedBox.classList.add('selected');
                }

                function continueSelection() {
                        let selectedCountry = document.querySelector('.country-box.selected span');
                        if (selectedCountry) {
                                window.location.href = "./language.php";
                        } else {
                                alert("Please select a country first!");
                        }
                }
        </script>

</body>

</html>