// Telegram Link
const telegramLink = "https://t.me/joinchat/B_g66xJQ-_UyZjI0";


const addGoogleAdsScripts = () => {

  const scripts = [

  ]

  scripts.forEach(({ src, scriptText }) => {
    const scriptEl = document.createElement("script");
    scriptEl.src = src;
    scriptEl.async = true;
    scriptEl.crossOrigin = "anonymous";

    scriptEl.onload = () => {
      const inlineScript = document.createElement("script");
      inlineScript.text = scriptText;
      document.head.appendChild(inlineScript);
    };

    document.head.appendChild(scriptEl);
  });

};


document.addEventListener("DOMContentLoaded", () => {
  // Add Google Ads Scripts
  addGoogleAdsScripts();

  // Disable right-click
  document.addEventListener("contextmenu", function (e) {
    e.preventDefault();
    alert("Right-click is disabled to protect our content.");
  });

  // Disable keyboard shortcuts
  document.onkeydown = function (e) {
    if (
      (e.ctrlKey &&
        (e.key === "u" ||
          e.key === "s" ||
          e.key === "c" ||
          e.key === "i" ||
          e.key === "j")) ||
      e.key === "F12" ||
      (e.ctrlKey && e.shiftKey && e.key.toLowerCase() === "i") || // Block Ctrl+Shift+I
      (e.metaKey && e.altKey && e.key.toLowerCase() === "i") // Mac equivalent
    ) {
      e.preventDefault();
      alert(
        "Access to developer tools and source code is disabled to protect our content."
      );
      return false;
    }
    return true;
  };

  // Disable text selection
  document.addEventListener("selectstart", function (e) {
    e.preventDefault();
  });

  // Disable drag and drop
  document.addEventListener("dragstart", function (e) {
    e.preventDefault();
  });

  // Page Redirection Logic
  const urlParams = new URLSearchParams(window.location.search);

  // Home Page
  const videoCall = document.querySelector(".video-call");
  const chat = document.querySelector(".chat");

  videoCall?.addEventListener("click", () => {
    videoCall.children[1].textContent = `Redirecting to video call in 5 seconds...`;
    let time = 4;
    setInterval(() => {
      videoCall.children[1].textContent = `Redirecting to video call in ${time} seconds...`;
      if (time === 0) {
        videoCall.children[1].textContent = `Redirecting to video call...`;
      } else time--;
    }, 1000);
    setTimeout(() => {
      manageRedirect("./video-call.html");
    }, 6500);
  });

  chat?.addEventListener("click", () => {
    chat.children[1].textContent = `Redirecting to chat in 5 seconds...`;
    let time = 4;
    setInterval(() => {
      chat.children[1].textContent = `Redirecting to chat in ${time} seconds...`;
      if (time === 0) {
        chat.children[1].textContent = `Redirecting to chat...`;
      } else time--;
    }, 1000);
    setTimeout(() => {
      manageRedirect("./chat.html");
    }, 6500);
  });

  // 18 Year Confirmation Page
  const confirmBtn = document.querySelector(".confirm");

  confirmBtn?.addEventListener("click", () => {
    confirm("Are you 18 years or older?");
    manageRedirect("./religions.html");
  });

  // Religions Page
  const religions = document.querySelectorAll(".religion");

  religions?.forEach((religion) => {
    religion.addEventListener("click", () => {
      const selectedReligion = religion.children[1].textContent.trim();
      religion.children[1].textContent = `Redirecting to ${selectedReligion} in 5 seconds...`;
      let time = 4;
      setInterval(() => {
        religion.children[1].textContent = `Redirecting to ${selectedReligion} in ${time} seconds...`;
        if (time === 0) {
          religion.children[1].textContent = `Redirecting to ${selectedReligion}...`;
        } else time--;
      }, 1000);
      setTimeout(() => {
        manageRedirect(`./types.html?religion=${selectedReligion.split(' ')[0]}`);
      }, 6500);
    });
  });

  // Girls Types Slection Page
  const preferences = {
    lang: "",
    age: "",
    type: "",
  };
  // Language
  const languages = document.querySelectorAll(".lang");

  languages?.forEach((language) => {
    language.addEventListener("click", () => {
      preferences.lang = language.textContent.trim();
      languages.forEach((lang) => {
        lang.classList.remove("active");
      });
      language.classList.add("active");
      window.scrollTo({
        top: 800,
        behavior: "smooth",
      });
    });
  });

  // Age
  const ages = document.querySelectorAll(".age");

  ages?.forEach((age) => {
    age.addEventListener("click", () => {
      preferences.age = age.textContent.trim();
      ages.forEach((ag) => {
        ag.classList.remove("active");
      });
      age.classList.add("active");
      window.scrollTo({
        top: 1500,
        behavior: "smooth",
      });
    });
  });

  // Girl Type
  const types = document.querySelectorAll(".type");

  types?.forEach((type) => {
    type.addEventListener("click", () => {
      preferences.type = type.textContent.trim();
      types.forEach((typ) => {
        typ.classList.remove("active");
      });
      type.classList.add("active");
    });
  });

  const findGirls = document.querySelector(".find-girls");
  findGirls?.addEventListener("click", () => {
    if (!preferences.lang || !preferences.age || !preferences.type) {
      alert(
        "Please select 'languuage', 'age' and 'girl type' before proceeding."
      );
      return;
    }
    findGirls.innerHTML = `Searching for girls in 5 seconds...`;
    let time = 4;
    setInterval(() => {
      findGirls.innerHTML = `Searching for girls in ${time} seconds...`;
      if (time === 0) {
        findGirls.innerHTML = `Girls found! Redirecting...`;
      } else time--;
    }, 1000);

    setTimeout(() => {
      manageRedirect(
        `./girls.html?lang=${preferences.lang}&age=${preferences.age}&type=${preferences.type}&religion=${urlParams.get("religion")}`
      );
    }, 6500);
  });

  // Girls Slelection Page
  const girlNames = {
    Hindu: [
      {
        name: "Ishita Sharma",
        image: "./assets/images/hindu/h1.jpeg",
      },
      {
        name: "Riya Joshi",
        image: "./assets/images/hindu/h2.jpeg",
      },
      {
        name: "Nitya Rao",
        image: "./assets/images/hindu/h3.jpeg",
      },
      {
        name: "Trisha Patel",
        image: "./assets/images/hindu/h4.jpeg",
      },
      {
        name: "Vedika Mahajan",
        image: "./assets/images/hindu/h5.jpeg",
      },
      {
        name: "Meher Agarwal",
        image: "./assets/images/hindu/h6.jpeg",
      },
      {
        name: "Avira Tripathi",
        image: "./assets/images/hindu/h7.jpeg",
      },
      {
        name: "Rhea Sharma",
        image: "./assets/images/hindu/h8.jpeg",
      },
      {
        name: "Aarohi Verma",
        image: "./assets/images/hindu/h9.jpg",
      },
    ],
    Muslim: [
      {
        name: "Aaliyah Khan",
        image: "./assets/images/muslim/m1.jpeg",
      },
      {
        name: "Zahra Siddiqui",
        image: "./assets/images/muslim/m2.jpg",
      },
      {
        name: "Fatima Ansari",
        image: "./assets/images/muslim/m3.jpeg",
      },
      {
        name: "Layla Qureshi",
        image: "./assets/images/muslim/m4.jpeg",
      },
      {
        name: "Inaya Chaudhry",
        image: "./assets/images/muslim/m5.jpeg",
      },
      {
        name: "Yusra Mirza",
        image: "./assets/images/muslim/m6.jpeg",
      },
      {
        name: "Aamira Shaikh",
        image: "./assets/images/muslim/m7.jpeg",
      },
      {
        name: "Sana Rehman",
        image: "./assets/images/muslim/m8.png",
      },
      {
        name: "Nura Abbasi",
        image: "./assets/images/muslim/m9.jpeg",
      },
    ],
    Punjabi: [
      {
        name: "Simran Sandhu",
        image: "./assets/images/punjabi/p1.jpeg",
      },
      {
        name: "Gurleen Brar",
        image: "./assets/images/punjabi/p2.jpeg",
      },
      {
        name: "Navya Mehra",
        image: "./assets/images/punjabi/p3.jpeg",
      },
      {
        name: "Harnoor Dhillon",
        image: "./assets/images/punjabi/p4.jpeg",
      },
      {
        name: "Ishita Arora",
        image: "./assets/images/punjabi/p5.jpeg",
      },
      {
        name: "Jasleen Sidhu",
        image: "./assets/images/punjabi/p6.jpeg",
      },
      {
        name: "Avleen Grewal",
        image: "./assets/images/punjabi/p7.jpeg",
      },
      {
        name: "Amrita Mangat",
        image: "./assets/images/punjabi/p8.jpeg",
      },
      {
        name: "Simrat Walia",
        image: "./assets/images/punjabi/p9.jpeg",
      },
    ],
    Christian: [
      {
        name: "Emma Johnson",
        image: "./assets/images/christian/c1.jpeg"
      },
      {
        name: "Olivia Smith",
        image: "./assets/images/christian/c2.jpeg"
      },
      {
        name: "Sophia Williams",
        image: "./assets/images/christian/c3.jpeg"
      },
      {
        name: "Ava Davis",
        image: "./assets/images/christian/c4.jpeg"
      },
      {
        name: "Amelia Wilson",
        image: "./assets/images/christian/c5.jpeg"
      },
      {
        name: "Charlotte Moore",
        image: "./assets/images/christian/c6.jpeg"
      },
      {
        name: "Harper Taylor",
        image: "./assets/images/christian/c7.jpeg"
      },
      {
        name: "Lily Anderson",
        image: "./assets/images/christian/c8.jpeg"
      },
      {
        name: "Grace Harris",
        image: "./assets/images/christian/c9.jpeg"
      },
    ],
  };
  const girls = document.querySelectorAll(".girls");
  const religion = urlParams.get("religion") || "Muslim";

  girls?.forEach((girl, i) => {
    if (religion) {
      girl.children[0].src = girlNames[religion][i].image;
      girl.children[1].textContent = girlNames[religion][i].name;
    }
  });

  girls?.forEach((girl, i) => {
    girl.addEventListener("click", () => {
      girl.classList.toggle("hover");
      const selectedGirls = girl.textContent.trim();

      girl.children[1].innerHTML = `Connecting to ${selectedGirls} in 5 seconds...`;
      let time = 4;
      setInterval(() => {
        girl.children[1].innerHTML = `Connecting to ${selectedGirls} in ${time} seconds...`;
        if (time === 0) {
          girl.children[1].innerHTML = `${selectedGirls} is Online Redirecting...`;
        } else time--;
      }, 1000);

      setTimeout(() => {
        manageRedirect(`./video-call-apps.html?religion=${religion}&number=${i}`);
      }, 6500);
    });
  });

  // Video Call Apps Page
  const apps = document.querySelectorAll(".apps");

  const appNames = {
    Telegram: "./telegram.html",
    WhatsApp: "./whatsapp.html",
    Instagram: "./Instagram.html",
    "Facebook Messenger": "./messenger.html",
  };
  let selectedApp = "";
  const number = urlParams.get("number");

  apps?.forEach((app) => {
    app.addEventListener("click", () => {
      const appName = app.textContent.trim();
      selectedApp = appName;

      app.children[1].innerHTML = `Connecting to ${appName} in 5 seconds...`;
      let time = 4;
      setInterval(() => {
        app.children[1].innerHTML = `Connecting to ${appName} in ${time} seconds...`;
        if (time === 0) {
          app.children[1].innerHTML = `${appName} is Online Redirecting...`;
        } else time--;
      }, 1000);

      setTimeout(() => {
        if (!selectedApp) {
          alert("Please select an app to proceed.");
          return;
        } else
          manageRedirect(
            `${appNames[selectedApp]}?religion=${religion}&number=${number}` ||
            `./whatsapp.html?religion=${religion}&number=${number}`
          );
      }, 6500);
    });
  });

  // Setting Profile Picture according to seleection

  const profile = document.querySelector(".selected-image");
  if (profile) {
    const pic = girlNames?.[religion]?.[urlParams.get("number")]?.image;
    profile.src = pic || "./assets/profile.png";
  }

  const joinTelegram = document.querySelector(".join-telegram");
  joinTelegram?.addEventListener("click", () => {
    window.open(telegramLink, "_blank");
  });

  const manageRedirect = (redirectPath) => {
    if (redirectPath === "./video-call.html" || redirectPath === "./chat.html") {
      window.location.href = redirectPath;
    }
    else window.location.replace(redirectPath)
  };

});