<?php
set_time_limit(0);

$baseUrl = "https://vcall.cktak.in/";
$baseDir = __DIR__ . "/assets/images/";

$images = [
    "hindu" => ["h1.jpeg","h2.jpeg","h3.jpeg","h4.jpeg","h5.jpeg","h6.jpeg","h7.jpeg","h8.jpeg","h9.jpg"],
    "muslim" => ["m1.jpeg","m2.jpg","m3.jpeg","m4.jpeg","m5.jpeg","m6.jpeg","m7.jpeg","m8.png","m9.jpeg"],
    "punjabi" => ["p1.jpeg","p2.jpeg","p3.jpeg","p4.jpeg","p5.jpeg","p6.jpeg","p7.jpeg","p8.jpeg","p9.jpeg"],
    "christian" => ["c1.jpeg","c2.jpeg","c3.jpeg","c4.jpeg","c5.jpeg","c6.jpeg","c7.jpeg","c8.jpeg","c9.jpeg"],
];

foreach ($images as $category => $files) {

    $folderPath = $baseDir . $category . "/";
    if (!is_dir($folderPath)) {
        mkdir($folderPath, 0755, true);
    }

    foreach ($files as $file) {
        $source = $baseUrl . "assets/images/$category/$file";
        $destination = $folderPath . $file;

        if (file_exists($destination)) {
            echo "✔ Already exists: $category/$file<br>";
            continue;
        }

        $imgData = @file_get_contents($source);
        if ($imgData === false) {
            echo "❌ Failed: $source<br>";
            continue;
        }

        file_put_contents($destination, $imgData);
        echo "✅ Downloaded: $category/$file<br>";
        flush();
    }
}

echo "<br><b>🎉 DONE — All images downloaded successfully</b>";
