-- Database: pinkvideo_admin
CREATE DATABASE IF NOT EXISTS `pinkvideo_admin` DEFAULT CHARACTER SET utf8mb4;

USE `pinkvideo_admin`;

-- Admin users table
CREATE TABLE `admin_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default admin
INSERT INTO `admin_users` (`username`, `password`, `email`) VALUES
('admin', '$2y$10$YourHashedPasswordHere', 'admin@yourdomain.com');

-- App users table
CREATE TABLE `app_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) NOT NULL,
  `device_id` varchar(255) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- App configuration table
CREATE TABLE `app_config` (
  `config_key` varchar(100) NOT NULL,
  `config_value` text DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`config_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default config
INSERT INTO `app_config` (`config_key`, `config_value`) VALUES
('webview_url', 'https://your-wordpress-site.com'),
('app_name', 'Pink Video Chat'),
('default_proxy', 'proxy1.example.com:1080'),
('contact_email', 'support@yourdomain.com');

-- Proxy list table
CREATE TABLE `proxy_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `proxy_name` varchar(100) NOT NULL,
  `proxy_host` varchar(255) NOT NULL,
  `proxy_port` int(11) NOT NULL,
  `proxy_type` enum('socks5','http','https') DEFAULT 'socks5',
  `is_active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert sample proxies
INSERT INTO `proxy_list` (`proxy_name`, `proxy_host`, `proxy_port`, `proxy_type`) VALUES
('USA Proxy 1', 'us1.proxy.com', 1080, 'socks5'),
('UK Proxy 1', 'uk1.proxy.com', 1080, 'socks5');

-- Revenue transactions table
CREATE TABLE `revenue_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;