package com.pubvance.videocall;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.webkit.*;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import okhttp3.*;
import org.json.JSONObject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MainActivity extends AppCompatActivity {
    
    private WebView webView;
    private OkHttpClient okHttpClient;
    private SharedPreferences prefs;
    private FrameLayout webViewContainer;
    private Button startBtn, adminBtn;
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        prefs = getSharedPreferences("VideoChatPrefs", MODE_PRIVATE);
        
        // Initialize views
        webViewContainer = findViewById(R.id.webViewContainer);
        startBtn = findViewById(R.id.startBtn);
        adminBtn = findViewById(R.id.adminBtn);
        
        // Set pink theme
        startBtn.setBackgroundColor(Color.parseColor("#FF69B4"));
        adminBtn.setBackgroundColor(Color.parseColor("#FFC0CB"));
        
        // Load saved URL or use default
        String defaultUrl = prefs.getString("webview_url", "https://google.com");
        
        // Setup proxy
        setupProxy();
        
        // Setup buttons
        startBtn.setOnClickListener(v -> {
            startBtn.setText("Connecting...");
            startBtn.setEnabled(false);
            initializeWebView(defaultUrl);
            webViewContainer.setVisibility(View.VISIBLE);
        });
        
        adminBtn.setOnLongClickListener(v -> {
            Intent intent = new Intent(MainActivity.this, AdminActivity.class);
            startActivity(intent);
            return true;
        });
    }
    
    private void setupProxy() {
        String proxyHost = prefs.getString("proxy_host", "your-proxy.com");
        int proxyPort = prefs.getInt("proxy_port", 1080);
        
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, 
            new InetSocketAddress(proxyHost, proxyPort));
        
        okHttpClient = new OkHttpClient.Builder()
            .proxy(proxy)
            .connectTimeout(30, TimeUnit.SECONDS)
            .readTimeout(30, TimeUnit.SECONDS)
            .addInterceptor(chain -> {
                Request original = chain.request();
                Request request = original.newBuilder()
                    .header("User-Agent", WebSettings.getDefaultUserAgent(this))
                    .build();
                return chain.proceed(request);
            })
            .build();
    }
    
    @SuppressLint("SetJavaScriptEnabled")
    private void initializeWebView(String url) {
        webView = new WebView(this);
        webViewContainer.addView(webView);
        
        WebSettings settings = webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
            settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        }
        
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        
        webView.loadUrl(url);
    }
    
    @Override
    public void onBackPressed() {
        if (webView != null && webView.canGoBack()) {
            webView.goBack();
        } else if (webViewContainer.getVisibility() == View.VISIBLE) {
            webViewContainer.setVisibility(View.GONE);
            startBtn.setVisibility(View.VISIBLE);
            startBtn.setText("Start Video Chat");
            startBtn.setEnabled(true);
        } else {
            super.onBackPressed();
        }
    }
}