package com.pubvance.videocall;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.*;
import androidx.appcompat.app.AppCompatActivity;

public class AdminActivity extends AppCompatActivity {
    
    private EditText urlEditText, proxyHostEditText, proxyPortEditText;
    private Button saveBtn;
    private SharedPreferences prefs;
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_admin);
        
        prefs = getSharedPreferences("VideoChatPrefs", MODE_PRIVATE);
        
        urlEditText = findViewById(R.id.urlEditText);
        proxyHostEditText = findViewById(R.id.proxyHostEditText);
        proxyPortEditText = findViewById(R.id.proxyPortEditText);
        saveBtn = findViewById(R.id.saveBtn);
        
        // Load saved settings
        urlEditText.setText(prefs.getString("webview_url", "https://google.com"));
        proxyHostEditText.setText(prefs.getString("proxy_host", "your-proxy.com"));
        proxyPortEditText.setText(String.valueOf(prefs.getInt("proxy_port", 1080)));
        
        saveBtn.setOnClickListener(v -> saveSettings());
    }
    
    private void saveSettings() {
        String url = urlEditText.getText().toString();
        String proxyHost = proxyHostEditText.getText().toString();
        String proxyPortStr = proxyPortEditText.getText().toString();
        
        if (url.isEmpty() || proxyHost.isEmpty() || proxyPortStr.isEmpty()) {
            Toast.makeText(this, "Please fill all fields", Toast.LENGTH_SHORT).show();
            return;
        }
        
        try {
            int proxyPort = Integer.parseInt(proxyPortStr);
            
            prefs.edit()
                .putString("webview_url", url)
                .putString("proxy_host", proxyHost)
                .putInt("proxy_port", proxyPort)
                .apply();
            
            Toast.makeText(this, "Settings saved!", Toast.LENGTH_SHORT).show();
            finish();
            
        } catch (NumberFormatException e) {
            Toast.makeText(this, "Invalid port number", Toast.LENGTH_SHORT).show();
        }
    }
}