<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* =========================
   GET TARGET URL
========================= */
$url = $_GET['url'] ?? '';
if (!$url) {
    die('No URL provided');
}

if (!preg_match('#^https?://#i', $url)) {
    $url = 'https://' . $url;
}

/* =========================
   LOAD PROXY
========================= */
$proxy = trim(file(__DIR__ . '/proxies.txt')[0]);

/* =========================
   CURL REQUEST (HTTP PROXY)
========================= */
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_CONNECTTIMEOUT => 15,

    CURLOPT_PROXY => $proxy,
    CURLOPT_PROXYTYPE => CURLPROXY_HTTP,

    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,

    CURLOPT_HTTPHEADER => [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
        'Accept: text/html,application/xhtml+xml',
    ],
]);

$response = curl_exec($ch);

if ($response === false) {
    die('Proxy error: ' . curl_error($ch));
}

curl_close($ch);

/* =========================
   BASIC URL REWRITE
========================= */
$response = preg_replace(
    '/(href|src)="(https?:\/\/[^"]+)"/i',
    '$1="/web?url=$2"',
    $response
);

echo $response;
