<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create assets folder
if (!is_dir('assets')) {
    mkdir('assets', 0755, true);
}

// index.php
file_put_contents('index.php',
'<!DOCTYPE html>
<html>
<head>
<title>Secure Web Proxy</title>
<link rel="stylesheet" href="assets/style.css">
</head>
<body>
<div class="box">
<h1>Secure Web Proxy</h1>
<form action="web" method="get">
<input name="url" placeholder="Enter website URL" required>
<button>Browse</button>
</form>
</div>
</body>
</html>'
);

// web.php
file_put_contents('web.php',
'<?php
if (!isset($_GET["url"])) {
    header("Location: /");
    exit;
}
require __DIR__ . "/proxy.php";'
);

// proxy.php
file_put_contents('proxy.php',
'<?php
$url = trim($_GET["url"]);
if (!preg_match("#^https?://#i", $url)) {
    $url = "https://" . $url;
}

$proxies = file(__DIR__ . "/proxies.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$proxy = $proxies ? trim($proxies[array_rand($proxies)]) : null;

$proxyHost = null;
$proxyAuth = null;
$proxyType = CURLPROXY_HTTP;

if ($proxy) {
    $p = parse_url($proxy);
    $proxyHost = $p["host"] . ":" . $p["port"];
    if (!empty($p["user"])) {
        $proxyAuth = $p["user"] . ":" . ($p["pass"] ?? "");
    }
    if (isset($p["scheme"]) && strtolower($p["scheme"]) === "socks5") {
        $proxyType = CURLPROXY_SOCKS5;
    }
}

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_TIMEOUT => 20,
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_HTTPHEADER => [
        "User-Agent: Mozilla/5.0",
        "X-Forwarded-For:",
        "Via:",
        "Forwarded:"
    ],
]);

if ($proxyHost) {
    curl_setopt($ch, CURLOPT_PROXY, $proxyHost);
    curl_setopt($ch, CURLOPT_PROXYTYPE, $proxyType);
    if ($proxyAuth) {
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxyAuth);
    }
}

$html = curl_exec($ch);
if ($html === false) {
    die("Proxy Error: " . curl_error($ch));
}
curl_close($ch);

$html = preg_replace(
    "/(href|src)=\"(https?:\/\/[^\"]+)\"/i",
    "$1=\"/web?url=$2\"",
    $html
);

echo $html;'
);

// .htaccess
file_put_contents('.htaccess',
'RewriteEngine On
RewriteRule ^web/?$ web.php [L,QSA]'
);

// proxies.txt
file_put_contents('proxies.txt',
'http://ip:port
socks5://ip:port
http://user:pass@ip:port'
);

// CSS
file_put_contents('assets/style.css',
'body{background:#0f172a;font-family:Arial;color:#fff}
.box{width:400px;margin:120px auto;background:#020617;padding:30px;border-radius:10px;text-align:center}
input{width:100%;padding:12px;margin:15px 0}
button{width:100%;padding:12px;background:#22c55e;border:none;font-weight:bold}'
);

echo "<h2>✅ Installed Successfully</h2>";
echo "<p>Now DELETE installer.php</p>";
