<?php
// proxy.php - Proxy Management
session_start();
require_once 'includes/config.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

$proxies = [
    ['id' => 1, 'name' => 'USA Proxy 1', 'host' => 'us1.proxy.com', 'port' => 1080, 'status' => 'active'],
    ['id' => 2, 'name' => 'UK Proxy 1', 'host' => 'uk1.proxy.com', 'port' => 1080, 'status' => 'active'],
    ['id' => 3, 'name' => 'Germany Proxy 1', 'host' => 'de1.proxy.com', 'port' => 1080, 'status' => 'inactive']
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proxy Management - Admin Panel</title>
    <?php include 'includes/head.php'; ?>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <div class="container mt-4">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header bg-pink text-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-server me-2"></i> Proxy Management</h5>
                        <button class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#addProxyModal">
                            <i class="fas fa-plus me-1"></i> Add Proxy
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Host</th>
                                        <th>Port</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($proxies as $proxy): ?>
                                    <tr>
                                        <td><?php echo $proxy['id']; ?></td>
                                        <td><?php echo $proxy['name']; ?></td>
                                        <td><?php echo $proxy['host']; ?></td>
                                        <td><?php echo $proxy['port']; ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $proxy['status'] == 'active' ? 'success' : 'danger'; ?>">
                                                <?php echo ucfirst($proxy['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary me-1">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Add Proxy Modal -->
    <div class="modal fade" id="addProxyModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-pink text-white">
                    <h5 class="modal-title">Add New Proxy</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="addProxyForm">
                        <div class="mb-3">
                            <label class="form-label">Proxy Name</label>
                            <input type="text" class="form-control" name="proxy_name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Host</label>
                            <input type="text" class="form-control" name="proxy_host" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Port</label>
                            <input type="number" class="form-control" name="proxy_port" value="1080" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Type</label>
                            <select class="form-control" name="proxy_type">
                                <option value="socks5">SOCKS5</option>
                                <option value="http">HTTP</option>
                                <option value="https">HTTPS</option>
                            </select>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-pink" onclick="addProxy()">Add Proxy</button>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/scripts.php'; ?>
    <script>
    function addProxy() {
        // In real app, send AJAX request to add proxy
        alert('Proxy added successfully!');
        $('#addProxyModal').modal('hide');
        location.reload();
    }
    </script>
</body>
</html>