<?php
// index.php - Admin Dashboard
session_start();

// Include required files
require_once 'includes/config.php';
require_once 'includes/functions.php';

// Check login
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

// Get stats
$stats = [
    'total_users' => getTotalUsers(),
    'active_users' => getActiveUsers(),
    'today_revenue' => getTodayRevenue(),
    'vip_users' => getVipUsers()
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pink Video Chat - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --pink: #FF69B4;
            --pink-dark: #FF1493;
            --pink-light: #FFC0CB;
        }
        body {
            background: linear-gradient(135deg, var(--pink-light), var(--pink));
            min-height: 100vh;
        }
        .navbar {
            background: var(--pink-dark);
        }
        .card {
            border-radius: 15px;
            border: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .card:hover {
            transform: translateY(-5px);
        }
        .stat-card {
            color: white;
            text-align: center;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .bg-users { background: linear-gradient(45deg, #667eea, #764ba2); }
        .bg-revenue { background: linear-gradient(45deg, #f093fb, #f5576c); }
        .bg-active { background: linear-gradient(45deg, #4facfe, #00f2fe); }
        .bg-vip { background: linear-gradient(45deg, #43e97b, #38f9d7); }
        .btn-pink {
            background: var(--pink);
            color: white;
            border: none;
        }
        .btn-pink:hover {
            background: var(--pink-dark);
            color: white;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">
                <i class="fas fa-video me-2"></i> Pink Video Chat Admin
            </a>
            <div class="d-flex align-items-center">
                <span class="text-white me-3">Welcome, <?php echo $_SESSION['admin_username']; ?></span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <a href="index.php" class="list-group-item list-group-item-action active">
                                <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                            </a>
                            <a href="users.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-users me-2"></i> Users
                            </a>
                            <a href="revenue.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-dollar-sign me-2"></i> Revenue
                            </a>
                            <a href="config.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-cog me-2"></i> Settings
                            </a>
                            <a href="proxy.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-server me-2"></i> Proxy
                            </a>
                            <a href="updates.php" class="list-group-item list-group-item-action">
                                <i class="fas fa-sync-alt me-2"></i> Updates
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <div class="row">
                    <div class="col-md-3">
                        <div class="stat-card bg-users">
                            <i class="fas fa-users fa-3x mb-3"></i>
                            <h4><?php echo $stats['total_users']; ?></h4>
                            <p>Total Users</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stat-card bg-active">
                            <i class="fas fa-user-check fa-3x mb-3"></i>
                            <h4><?php echo $stats['active_users']; ?></h4>
                            <p>Active Users</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stat-card bg-revenue">
                            <i class="fas fa-dollar-sign fa-3x mb-3"></i>
                            <h4>$<?php echo number_format($stats['today_revenue'], 2); ?></h4>
                            <p>Today's Revenue</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="stat-card bg-vip">
                            <i class="fas fa-crown fa-3x mb-3"></i>
                            <h4><?php echo $stats['vip_users']; ?></h4>
                            <p>VIP Users</p>
                        </div>
                    </div>
                </div>

                <div class="card mt-4">
                    <div class="card-header bg-pink text-white">
                        <h5 class="mb-0"><i class="fas fa-cog me-2"></i> Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <button class="btn btn-pink w-100" onclick="location.href='config.php'">
                                    <i class="fas fa-edit me-2"></i> Change WebView URL
                                </button>
                            </div>
                            <div class="col-md-4 mb-3">
                                <button class="btn btn-pink w-100" onclick="location.href='proxy.php'">
                                    <i class="fas fa-server me-2"></i> Manage Proxies
                                </button>
                            </div>
                            <div class="col-md-4 mb-3">
                                <button class="btn btn-pink w-100" onclick="location.href='updates.php'">
                                    <i class="fas fa-upload me-2"></i> Upload APK
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>