<?php
// config.php - App Configuration
session_start();
require_once 'includes/config.php';
require_once 'includes/functions.php';

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit();
}

$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $webview_url = $_POST['webview_url'] ?? '';
    $app_name = $_POST['app_name'] ?? '';
    $contact_email = $_POST['contact_email'] ?? '';
    
    // Save to database or config file
    $configData = [
        'webview_url' => $webview_url,
        'app_name' => $app_name,
        'contact_email' => $contact_email,
        'updated_at' => date('Y-m-d H:i:s')
    ];
    
    // In real app, save to database
    file_put_contents('config/app_config.json', json_encode($configData, JSON_PRETTY_PRINT));
    
    $message = '<div class="alert alert-success">Settings saved successfully!</div>';
}

// Load current settings
$currentConfig = file_exists('config/app_config.json') 
    ? json_decode(file_get_contents('config/app_config.json'), true)
    : [
        'webview_url' => 'https://your-wordpress-site.com',
        'app_name' => 'Pink Video Chat',
        'contact_email' => 'support@yourdomain.com'
    ];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>App Settings - Admin Panel</title>
    <?php include 'includes/head.php'; ?>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>
    
    <div class="container mt-4">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header bg-pink text-white">
                        <h5 class="mb-0"><i class="fas fa-cog me-2"></i> App Configuration</h5>
                    </div>
                    <div class="card-body">
                        <?php echo $message; ?>
                        
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">App Name</label>
                                <input type="text" name="app_name" class="form-control" 
                                       value="<?php echo htmlspecialchars($currentConfig['app_name']); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">WebView URL</label>
                                <input type="url" name="webview_url" class="form-control" 
                                       value="<?php echo htmlspecialchars($currentConfig['webview_url']); ?>" required>
                                <small class="text-muted">This URL will load in the app's WebView</small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Contact Email</label>
                                <input type="email" name="contact_email" class="form-control" 
                                       value="<?php echo htmlspecialchars($currentConfig['contact_email']); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Default Proxy</label>
                                <select name="default_proxy" class="form-control">
                                    <option value="proxy1.example.com:1080">USA Proxy 1</option>
                                    <option value="proxy2.example.com:1080">UK Proxy 1</option>
                                    <option value="proxy3.example.com:1080">Germany Proxy 1</option>
                                </select>
                            </div>
                            
                            <button type="submit" class="btn btn-pink">
                                <i class="fas fa-save me-2"></i> Save Settings
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/scripts.php'; ?>
</body>
</html>