// assets/js/admin.js - Common admin JavaScript

// Initialize tooltips
$(document).ready(function() {
    $('[data-bs-toggle="tooltip"]').tooltip();
    
    // Initialize popovers
    $('[data-bs-toggle="popover"]').popover();
    
    // Confirm on delete buttons
    $('.btn-delete').on('click', function(e) {
        if (!confirm('Are you sure you want to delete this item?')) {
            e.preventDefault();
        }
    });
    
    // Auto-submit forms on select change
    $('.auto-submit').on('change', function() {
        $(this).closest('form').submit();
    });
    
    // Copy to clipboard
    $('.copy-btn').on('click', function() {
        var text = $(this).data('copy');
        navigator.clipboard.writeText(text).then(function() {
            alert('Copied to clipboard!');
        });
    });
});

// AJAX functions
function ajaxRequest(url, data, method = 'POST') {
    return $.ajax({
        url: url,
        type: method,
        data: data,
        dataType: 'json'
    });
}

// Update proxy status
function updateProxyStatus(proxyId, status) {
    if (confirm('Change proxy status?')) {
        $.post('ajax/update_proxy.php', {
            id: proxyId,
            status: status
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + response.message);
            }
        }, 'json');
    }
}

// Test proxy connection
function testProxy(proxyId) {
    $('#testBtn' + proxyId).html('<i class="fas fa-spinner fa-spin"></i> Testing...');
    
    $.post('ajax/test_proxy.php', {
        id: proxyId
    }, function(response) {
        if (response.success) {
            $('#testBtn' + proxyId).html('<i class="fas fa-check"></i> Working');
            $('#statusBadge' + proxyId).removeClass('bg-danger').addClass('bg-success').text('Active');
        } else {
            $('#testBtn' + proxyId).html('<i class="fas fa-times"></i> Failed');
            alert('Proxy test failed: ' + response.message);
        }
    }, 'json');
}

// Send notification
function sendNotification() {
    var title = $('#notificationTitle').val();
    var message = $('#notificationMessage').val();
    var target = $('#notificationTarget').val();
    
    if (!title || !message) {
        alert('Please fill all fields');
        return;
    }
    
    if (confirm('Send notification to all users?')) {
        $.post('ajax/send_notification.php', {
            title: title,
            message: message,
            target: target
        }, function(response) {
            if (response.success) {
                alert('Notification sent successfully!');
                $('#notificationTitle, #notificationMessage').val('');
            } else {
                alert('Error: ' + response.message);
            }
        }, 'json');
    }
}

// Upload APK
function uploadApk() {
    var formData = new FormData($('#uploadApkForm')[0]);
    
    $('#uploadBtn').html('<i class="fas fa-spinner fa-spin"></i> Uploading...');
    $('#uploadBtn').prop('disabled', true);
    
    $.ajax({
        url: 'ajax/upload_apk.php',
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(response) {
            if (response.success) {
                alert('APK uploaded successfully!');
                location.reload();
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function() {
            alert('Upload failed. Please try again.');
        },
        complete: function() {
            $('#uploadBtn').html('<i class="fas fa-upload"></i> Upload APK');
            $('#uploadBtn').prop('disabled', false);
        }
    });
}

// Load statistics chart
function loadStatsChart() {
    $.get('ajax/get_stats.php', function(data) {
        if (data.success) {
            var ctx = document.getElementById('statsChart').getContext('2d');
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: data.labels,
                    datasets: [{
                        label: 'Active Users',
                        data: data.active_users,
                        borderColor: '#FF69B4',
                        backgroundColor: 'rgba(255, 105, 180, 0.1)',
                        tension: 0.4
                    }, {
                        label: 'Revenue',
                        data: data.revenue,
                        borderColor: '#36A2EB',
                        backgroundColor: 'rgba(54, 162, 235, 0.1)',
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'top',
                        }
                    }
                }
            });
        }
    }, 'json');
}

// Export data
function exportData(type) {
    window.location.href = 'ajax/export.php?type=' + type;
}

// Search users
function searchUsers() {
    var search = $('#userSearch').val();
    window.location.href = 'users.php?search=' + encodeURIComponent(search);
}

// Clear search
function clearSearch() {
    window.location.href = 'users.php';
}

// Toggle sidebar on mobile
function toggleSidebar() {
    $('.sidebar').toggleClass('d-none d-md-block');
}

// Initialize when document is ready
$(function() {
    // Load chart if element exists
    if ($('#statsChart').length) {
        loadStatsChart();
    }
    
    // Initialize datepickers
    if ($('.datepicker').length) {
        $('.datepicker').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true
        });
    }
    
    // Auto-refresh dashboard every 60 seconds
    if (window.location.pathname.includes('index.php')) {
        setInterval(function() {
            $('#userStats').load(' #userStats > *');
            $('#revenueStats').load(' #revenueStats > *');
        }, 60000);
    }
});