<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Live Video Call</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{box-sizing:border-box}
body{
  margin:0;
  background:#000;
  font-family:Arial,Helvetica,sans-serif;
  color:#fff;
  overflow:hidden;
}
header{
  height:50px;
  background:#0d0d0d;
  display:flex;
  align-items:center;
  justify-content:center;
  font-size:16px;
  font-weight:600;
}
.call-wrap{
  position:relative;
  width:100%;
  height:calc(100vh - 110px);
  background:#000;
  overflow:hidden;
}
#remoteVideo{
  width:100%;
  height:100%;
  object-fit:cover;
  filter: blur(6px);
  transform: scale(1.05);
}
.blur-layer{
  position:absolute;
  inset:0;
  backdrop-filter: blur(10px);
  background:rgba(0,0,0,.15);
}
#localVideo{
  position:absolute;
  right:12px;
  bottom:12px;
  width:110px;
  height:160px;
  object-fit:cover;
  border-radius:12px;
  border:2px solid rgba(255,255,255,.6);
  background:#000;
  z-index:5;
}
#ringing{
  position:absolute;
  inset:0;
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:center;
  background:#000;
  z-index:10;
}
.loader{
  width:50px;
  height:50px;
  border:4px solid #333;
  border-top:4px solid #00ff99;
  border-radius:50%;
  animation:spin 1s linear infinite;
  margin-bottom:15px;
}
@keyframes spin{to{transform:rotate(360deg)}}
.controls{
  height:60px;
  background:#0d0d0d;
  display:flex;
  align-items:center;
  justify-content:center;
  gap:14px;
}
.ctrl{
  width:48px;
  height:48px;
  border-radius:50%;
  border:none;
  cursor:pointer;
}
.mic,.cam{background:#333;color:#fff}
.end{background:#e53935;color:#fff}
</style>
</head>

<body>

<header>Live Video Call</header>

<div class="call-wrap">

  <!-- Ringing screen -->
  <div id="ringing">
    <div class="loader"></div>
    <div>Connecting</div>
  </div>

  <!-- Remote random video -->
  <video id="remoteVideo" autoplay muted loop playsinline></video>

  <div class="blur-layer"></div>

  <!-- User camera -->
  <video id="localVideo" autoplay muted playsinline></video>

</div>

<div class="controls">
  <button class="ctrl mic" onclick="toggleMic()">Mic</button>
  <button class="ctrl cam" onclick="toggleCam()">Cam</button>
  <button class="ctrl end" onclick="endCall()">End</button>
</div>

<script>
/* ===============================
   RANDOM REMOTE VIDEO
   =============================== */
const remoteVideos = [
  "/vc3/assets/videos/v1.mp4",
  "assets/videos/v2.mp4",
  "assets/videos/v3.mp4",
  "assets/videos/v4.mp4"
];

const remoteVideo = document.getElementById("remoteVideo");
const randomVideo = remoteVideos[Math.floor(Math.random() * remoteVideos.length)];
remoteVideo.src = randomVideo;

/* ===============================
   CAMERA + CALL FLOW
   =============================== */
let stream, camOn=true, micOn=true;

function startCamera(){
  navigator.mediaDevices.getUserMedia({video:true,audio:true})
    .then(s=>{
      stream=s;
      localVideo.srcObject=s;
    })
    .catch(()=>{});
}

function toggleCam(){
  if(!stream) return;
  camOn=!camOn;
  stream.getVideoTracks().forEach(t=>t.enabled=camOn);
}

function toggleMic(){
  if(!stream) return;
  micOn=!micOn;
  stream.getAudioTracks().forEach(t=>t.enabled=micOn);
}

function endCall(){
  if(stream) stream.getTracks().forEach(t=>t.stop());
  location.href="1.php";
}

/* ===============================
   FAKE RINGING DELAY
   =============================== */
setTimeout(()=>{
  document.getElementById("ringing").style.display="none";
  startCamera();
},3000);
</script>

</body>
</html>
