<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Live Talk Video Call</title>

<link rel="stylesheet" href="style.css">

<script>
/*
  🔥 HARD OVERRIDE SEQUENCE CONTROLLER
  Works even if buttons have href / onclick / JS
*/
(function(){

  const pages = [
    "1.php","2.php","3.php","4.php",
    "5.php","6.php","7.php","8.php"
  ];

  function getCurrentPage(){
    return location.pathname.split("/").pop();
  }

  function getNextPage(){
    const cur = getCurrentPage();
    const idx = pages.indexOf(cur);
    if(idx === -1) return pages[0];
    return pages[idx + 1] || pages[0];
  }

  // 🔥 CAPTURE PHASE (MOST IMPORTANT)
  document.addEventListener("click", function(e){

    const target = e.target;

    // Ignore ads / scripts
    if (
      target.closest("iframe") ||
      target.closest(".adsbygoogle") ||
      target.closest("[id*='ad']")
    ) return;

    // ANY clickable element
    if (
      target.closest("a") ||
      target.closest("button") ||
      target.closest("[onclick]") ||
      target.closest("img")
    ){
      e.preventDefault();
      e.stopImmediatePropagation(); // 🔥 key
      e.stopPropagation();

      location.replace(getNextPage());
    }

  }, true); // 👈 CAPTURE MODE

})();
</script>

</head>

<body>

<header class="site-header">
  Live Talk Video Call
</header>
