<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap"
                rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat center top;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        align-items: center;
                        justify-content: center;
                }

                .title {
                        font-size: 24px;
                        font-weight: 600;
                        color: #ff1493;
                }

                .highlight {
                        font-weight: 700;
                }

                .image-container {
                        margin: 20px 0;
                }

                .image-container img {
                        width: 80%;
                        height: 80%;
                }

                .priority-text {
                        color: #888;
                        font-size: 14px;
                }

                .invite-text {
                        font-size: 16px;
                        font-weight: 600;
                        color: #000;
                        text-decoration: underline;
                        margin-top: 5px;
                        cursor: pointer;
                }

                .share-text {
                        font-size: 14px;
                        color: #666;
                        margin-top: 20px;
                }

                .btn {
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        width: 100%;
                        max-width: 320px;
                        padding: 12px;
                        border-radius: 30px;
                        margin: 10px auto;
                        font-size: 16px;
                        font-weight: 600;
                        color: #fff;
                        cursor: pointer;
                        border: none;
                        outline: none;
                }

                .whatsapp {
                        background: linear-gradient(45deg, #ff0080, #ff8c00);
                }

                .facebook {
                        background: linear-gradient(45deg, #a800ff, #ff4081);
                }

                .skip-btn {
                        background: #888;
                        color: white;
                        font-size: 14px;
                        padding: 10px 20px;
                        border-radius: 20px;
                        border: none;
                        margin-top: 10px;
                        cursor: pointer;
                }

                .icon {
                        margin-right: 10px;
                }

                @media screen and (min-width: 768px) {
                        body {
                                width: 400px;
                                margin: auto;
                                padding: 0;
                        }
                }
        </style>
</head>

<body>
        <div class="container">
                <?php
                include('./ad_responsive.php');
                ?>
                <h2 class="title">Scheduled <span class="highlight">5 Minutes!</span></h2>
                <div class="image-container">
                        <img src="./image/share.png" alt="Illustration" width="100%">
                </div>
                <p class="priority-text">Want Priority Access?</p>
                <p class="invite-text">Invite A Friend To Get Priority Access!</p>
                <p class="share-text">Share On:</p>
                <button class="btn whatsapp"><span class="icon">📱</span> Whatsapp</button>
                <button class="btn facebook"><span class="icon">📘</span> Facebook</button>
                <a href="./access.php"><button class="skip-btn">Skip</button></a>
                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>
</body>

</html>