<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat top center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        justify-content: center;
                        align-items: center;
                }

                .title {
                        font-size: 28px;
                        font-weight: 600;
                        color: #ff66b2;
                        text-align: left;
                }

                .title span {
                        color: #8a2be2;
                }

                .server-container {
                        display: grid;
                        grid-template-columns: repeat(2, 1fr);
                        gap: 10px;
                        justify-content: center;
                        align-items: center;
                        max-width: 400px;
                        margin-top: 10px;
                }

                /* Server Box */
                .server-box {
                        border-radius: 28px;
                        text-align: center;
                        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
                        transition: transform 0.3s ease-in-out, border 0.3s ease-in-out;
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                        justify-content: center;
                        cursor: pointer;
                        /* border: 3px solid transparent; */
                }

                .server-box:hover {
                        transform: translateY(-5px);
                }

                /* Highlight selected server */
                .server-box.selected {
                        border: 3px solid #ffffff;
                        box-shadow: 0 4px 20px rgba(255, 102, 178, 0.5);
                }

                .server-box img {
                        width: 100%;
                        height: 100%;
                }

                /* Next Button */
                .next-btn {
                        display: none;
                        background: linear-gradient(to right, #a233ff, #ff7eb3);
                        border: none;
                        padding: 15px 20px;
                        color: white;
                        font-size: 16px;
                        font-weight: bold;
                        border-radius: 30px;
                        cursor: pointer;
                        width: 90%;
                        max-width: 300px;
                        transition: 0.3s;
                        margin-top: 20px;
                        margin-left: 30px;
                }

                .next-btn:hover {
                        opacity: 0.9;
                }


                @media screen and (min-width: 768px) {
                        body {
                                width: 400px;
                                margin: auto;
                                padding: 0;
                        }
                }
        </style>
</head>

<body>

        <div class="container">
                <h1 class="title">Server <span>Room</span></h1>
                <?php
                include('./ad_responsive.php');
                ?>

                <div class="server-container">
                        <div class="server-box" onclick="selectServer(1)">
                                <img src="./image/server1.png" alt="Server 1">
                        </div>
                        <div class="server-box" onclick="selectServer(2)">
                                <img src="./image/server2.png" alt="Server 2">
                        </div>
                        <div class="server-box" onclick="selectServer(3)">
                                <img src="./image/server3.png" alt="Server 3">
                        </div>
                        <div class="server-box" onclick="selectServer(4)">
                                <img src="./image/server4.png" alt="Server 4">
                        </div>
                </div>

                <button class="next-btn" id="nextBtn" onclick="goToNextPage()">Next</button>

                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>

        <script>
                let selectedServer = null;

                function selectServer(serverNumber) {
                        // Remove 'selected' class from all server boxes
                        document.querySelectorAll('.server-box').forEach(box => {
                                box.classList.remove('selected');
                        });

                        // Get the clicked server box and highlight it
                        let selectedBox = document.querySelectorAll('.server-box')[serverNumber - 1];
                        selectedBox.classList.add('selected');

                        // Update selected server
                        selectedServer = serverNumber;

                        // Show "Next" button
                        document.getElementById("nextBtn").style.display = "block";
                }

                function goToNextPage() {
                        if (selectedServer) {
                                window.location.href = "/verify.php";
                        }
                }
        </script>

</body>

</html>