<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat center top;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        align-items: center;
                        justify-content: center;
                }

                h2 {
                        font-size: 22px;
                        font-weight: 600;
                        color: #ff4ecb;
                        text-align: left;
                }

                h3 {
                        font-size: 26px;
                        font-weight: 700;
                        color: #aa00ff;
                        margin-bottom: 20px;
                        text-align: left;
                }

                .language-btn {
                        display: block;
                        width: 100%;
                        padding: 12px;
                        margin: 8px 0;
                        font-size: 18px;
                        font-weight: 500;
                        border-radius: 10px;
                        border: 2px solid #ddd;
                        background-color: #fff;
                        color: #333;
                        cursor: pointer;
                        transition: all 0.3s ease-in-out;
                }

                .language-btn.active {
                        /* background: linear-gradient(90deg, #ff4ecb, #ff7b69); */
                        background-color: #ffccf2;
                        border-color: #ff4ecb;
                        color: #ff3399;
                        font-weight: 600;
                }

                .language-btn:hover {
                        background: #ffe6f7;
                        border-color: #ff4ecb;
                        color: #ff3399;
                }

                .continue-btn {
                        width: 100%;
                        padding: 15px;
                        font-size: 20px;
                        font-weight: 600;
                        text-align: center;
                        color: #fff;
                        border-radius: 30px;
                        background: linear-gradient(to right, #a93af5, #ff3399, #ff9966);
                        border: none;
                        cursor: pointer;
                        margin-top: 20px;
                        transition: 0.3s;
                }

                .continue-btn:hover {
                        opacity: 0.9;
                }

                a {
                        text-decoration: none;
                }

                @media (max-width: 400px) {
                        .container {
                                width: 95%;
                                padding: 20px;
                        }

                        h2 {
                                font-size: 20px;
                        }

                        h3 {
                                font-size: 22px;
                        }

                        .language-btn {
                                font-size: 16px;
                                padding: 10px;
                        }

                        .continue-btn {
                                font-size: 18px;
                                padding: 12px;
                        }
                }
        </style>
</head>

<body>
        <div class="container">
                <?php
                include('./ad_responsive.php');
                ?>
                <h2>Select</h2>
                <h3>Your Language</h3>

                <button class="language-btn" onclick="selectLanguage(this)">English</button>
                <button class="language-btn" onclick="selectLanguage(this)">Hindi</button>
                <button class="language-btn" onclick="selectLanguage(this)">Spanish</button>
                <button class="language-btn" onclick="selectLanguage(this)">French</button>
                <button class="language-btn" onclick="selectLanguage(this)">German</button>
                <button class="language-btn" onclick="selectLanguage(this)">Russian</button>
                <button class="language-btn" onclick="selectLanguage(this)">Korean</button>
                <button class="language-btn" onclick="selectLanguage(this)">Indonesian</button>

                <a href="./"><button class="continue-btn">Continue</button></a>
                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>

        <script>
                function selectLanguage(selectedBtn) {
                        document.querySelectorAll('.language-btn').forEach(btn => {
                                btn.classList.remove('active');
                        });
                        selectedBtn.classList.add('active');
                }
        </script>
</body>

</html>