<!DOCTYPE html>
<html lang="en">

<head>
        <?php
        include('./ad_header_tag.php');
        ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat top center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                }

                h1 {
                        color: #FB43B4;
                        font-size: 28px;
                        font-weight: 600;
                        text-align: left;
                        margin-bottom: 15px;
                }

                .heart img {
                        width: 250px;
                        height: 250px;
                        border-radius: 100%;
                        margin-bottom: -50px;
                }

                /* Gender Selection */
                .gender-selection {
                        display: flex;
                        gap: 15px;
                        margin-bottom: 30px;
                        justify-content: center;
                }

                .gender-card {
                        width: 150px;
                        height: 150px;
                        border-radius: 15px;
                        padding: 10px;
                        text-align: center;
                        cursor: pointer;
                        transition: 0.3s;
                        display: flex;
                        flex-direction: column;
                        justify-content: center;
                        align-items: center;
                        font-size: 14px;
                }

                .gender-card img {
                        width: 60px;
                        height: 60px;
                }

                .gender-card p {
                        font-size: 16px;
                        margin-top: 10px;
                        font-weight: bold;
                }


                .gender-card {
                        border: 2px solid #ff7eb3;
                        color: #333;
                }

                .gender-card:hover {
                        transform: scale(1.05);
                }

                /* Selected Gender */
                .selected {
                        background: linear-gradient(to right, #d233ff, #ff7eb3) !important;
                        color: white !important;
                        border: none !important;
                        box-shadow: 0px 5px 15px rgba(255, 0, 153, 0.4);
                }

                /* Continue Button */
                .continue-btn {
                        background: linear-gradient(to right, #a233ff, #ff7eb3);
                        border: none;
                        padding: 15px 20px;
                        color: white;
                        font-size: 16px;
                        font-weight: bold;
                        border-radius: 30px;
                        cursor: pointer;
                        width: 90%;
                        max-width: 300px;
                        transition: 0.3s;
                }

                .continue-btn:hover {
                        opacity: 0.9;
                }

                @media screen and (min-width: 768px) {
                        body {
                                width: 400px;
                                margin: auto;
                                padding: 0;
                        }
                }
        </style>
</head>

<body>
        <div class="container">
                <h1>Gender</h1>
                <?php
                include('./ad_responsive.php');
                ?>


                <!-- Heart Icon -->
                <div class="heart-container">
                        <div class="heart">
                                <img src="./image/like.png" alt="Heart Icon">
                        </div>
                </div>


                <!-- Gender Selection -->
                <div class="gender-selection">
                        <div class="gender-card" data-gender="Male" onclick="selectGender(this)">
                                <img src="./image/male.png" alt="Male Icon">
                                <p>Male</p>
                        </div>
                        <div class="gender-card" data-gender="Female" onclick="selectGender(this)">
                                <img src="./image/female.png" alt="Female Icon">
                                <p>Female</p>
                        </div>
                        <div class="gender-card" data-gender="Both" onclick="selectGender(this)">
                                <img src="./image/both.png" alt="Both Icon">
                                <p>Both</p>
                        </div>
                </div>

                <!-- Continue Button -->
                <a href="./next.php"><button class="continue-btn">Continue</button></a>

                <script>
                        let selectedGender = '';

                        function selectGender(element) {
                                document.querySelectorAll('.gender-card').forEach(card => card.classList.remove('selected'));
                                element.classList.add('selected');
                                selectedGender = element.getAttribute('data-gender');
                        }
                </script>

                <?php
                include('./ad_responsive2.php');
                ?>
                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd"
                        style="position: fixed; bottom: 0px; left: 0; width: 100%; color:rgb(255, 255, 255); background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php
                        include('./ad_banner.php');
                        ?>
                </div>
        </div>
</body>

</html>