<!DOCTYPE html>
<html lang="en">

<head>
        <?php include('./ad_header_tag.php'); ?>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Live Video Call</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
        <style>
                * {
                        margin: 0;
                        padding: 0;
                        box-sizing: border-box;
                        font-family: 'Poppins', sans-serif;
                }

                body {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        min-height: 100vh;
                        background: #f5f5f5;
                }

                .container {
                        width: 100%;
                        max-width: 400px;
                        padding: 20px;
                        background: url('./image/explorebg.png') no-repeat top center;
                        background-size: cover;
                        text-align: center;
                        border-radius: 10px;
                        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
                        justify-content: center;
                        align-items: center;
                }

                .title,
                .titlebefore {
                        font-size: 22px;
                        font-weight: 600;
                        color: #ff40a5;
                        margin-bottom: 20px;
                        margin-top: 80px;
                }

                .title {
                        display: none;
                }

                .image-container {
                        display: none;
                }

                .image-container img {
                        width: 100px;
                        margin-bottom: 15px;
                }

                .loader {
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        height: 100px;
                }

                .loader div {
                        width: 15px;
                        height: 15px;
                        margin: 5px;
                        background-color: #ff40a5;
                        border-radius: 50%;
                        animation: bounce 1.5s infinite ease-in-out;
                }

                .loader div:nth-child(2) {
                        animation-delay: 0.2s;
                }

                .loader div:nth-child(3) {
                        animation-delay: 0.4s;
                }

                @keyframes bounce {

                        0%,
                        80%,
                        100% {
                                transform: scale(0);
                        }

                        40% {
                                transform: scale(1);
                        }
                }

                .message {
                        font-size: 16px;
                        color: #444;
                        font-weight: 400;
                }

                .button {
                        display: inline-block;
                        padding: 12px 80px;
                        font-size: 16px;
                        font-weight: 600;
                        color: #fff;
                        border: none;
                        border-radius: 30px;
                        background: linear-gradient(90deg, #a735ff, #ff6b99);
                        text-decoration: none;
                        margin-top: 20px;
                        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
                        transition: all 0.3s ease;
                }

                .button:hover {
                        opacity: 0.9;
                }

                @media screen and (min-width: 768px) {
                        body {
                                width: 400px;
                                margin: auto;
                                padding: 0;
                        }
                }
        </style>
        <script>
                document.addEventListener("DOMContentLoaded", function() {
                        setTimeout(function() {
                                document.querySelector(".loader").style.display = "none";
                                document.querySelector(".image-container").style.display = "block";
                                document.querySelector(".titlebefore").style.display = "none";
                                document.querySelector(".title").style.display = "block";
                        }, 4000);
                });
        </script>
</head>

<body>
        <div class="container">
                <?php include('./ad_responsive.php'); ?>

                <div class="titlebefore">Connecting...</div>
                <div class="title">Connection Issue</div>

                <div class="loader">
                        <div></div>
                        <div></div>
                        <div></div>
                </div>

                <div class="image-container">
                        <img src="./image/connectionalert.png" alt="Warning Icon">
                </div>

                <div class="message">Connection Lost?<br>Reconnect!</div>
                <a href="./spinwheel.php" class="button">Reconnect</a>

                <?php include('./ad_responsive2.php'); ?>

                <p style="margin-top: 30px; margin-bottom: 10px;">
                        <?php
                        include('./ad_ecpm_content.php');
                        ?>
                </p>
                <p style="margin-top: 1px; margin-bottom: 150px;">
                        <?php
                        include('./ad_content.php');
                        ?>
                </p>

                <div id="bannerAd" style="position: fixed; bottom: 0; left: 0; width: 100%; background-color: #fff; text-align: center; padding: 0px; box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
                        <?php include('./ad_banner.php'); ?>
                </div>
        </div>
</body>

</html>