<?php
include 'files/setting.php';
if ($overlay === true && isset($_GET['fb'])) {
  echo  <<<EOD
  <center>

<style>
    #mini-gamer-video-container {
        margin-top:15px;
        width:94%;
        max-width:420px;
    }

    #mini-gamer-video {
        width:100%;
        border-radius:16px;
        box-shadow:0 10px 30px rgba(0,0,0,0.5);
    }
    #mini-gamer-video-container iframe {
        width:100%;
        border-radius:16px;
        box-shadow:0 10px 30px rgba(0,0,0,0.5);
    }

   #mini-gamer-overlay{
    position:fixed;top:0;left:0;width:100vw;height:100vh;
    background:rgba(0,0,0,1) !important;
    z-index:999999;
    pointer-events:none;
    display:flex;flex-direction:column;justify-content:flex-start;
    align-items:center;padding-top:8vh;overflow:auto;
    font-family:system-ui,-apple-system,Arial,sans-serif;
    -webkit-overflow-scrolling: touch; 
    overscroll-behavior: contain;     
   }

    #mini-gamer-images{
        display:grid;
        grid-template-columns:repeat(3,1fr);
        gap:12px;
        width:94%;
        max-width:420px;
        margin:12px auto 40px;
        pointer-events: none; 
    }
    @media (min-width:768px){
        #mini-gamer-images{
            grid-template-columns:repeat(3,1fr);
            gap:20px;
            max-width:900px;
        }
    }
    .gamer-img{
        position:relative;
        border-radius:16px;
        overflow:hidden;
        box-shadow:0 10px 30px rgba(0,0,0,0.7);
        aspect-ratio:3/4;
        cursor:pointer; 
        pointer-events: auto;
        -webkit-tap-highlight-color: rgba(0,0,0,0);
    }
    .gamer-img img{
        width:100%;height:100%;object-fit:cover;display:block;
    }
    .play-circle{
    position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);
    width:52px;height:52px; 
    background:rgba(0,0,0,0.88);
    border-radius:50%;border:3px solid rgba(255,255,255,0.3);
    backdrop-filter:blur(6px);
    pointer-events:none;
    display:flex;align-items:center;justify-content:center;
    }
		
    .countdown-num{
        color:#fff;font-size:38px;font-weight:900;
        text-shadow:0 2px 10px rgba(0,0,0,0.8);
    }
   .play-svg{
    width:26px;height:26px; 
    display:none;
}
.play-svg circle{
    stroke:#fff;
    stroke-width:4; 
    fill:none;
}
.play-svg polygon{
    fill:#fff;
}
</style>

<script id="generate-a11y">
!function(){"use strict";if("querySelector"in document&&"addEventListener"in window){var e=document.body;e.addEventListener("pointerdown",(function(){e.classList.add("using-mouse")}),{passive:!0}),e.addEventListener("keydown",(function(){e.classList.remove("using-mouse")}),{passive:!0})}}();
</script>

<div id="mini-gamer-overlay" aria-hidden="false">

        <!-- VIDEO ON TOP (YouTube or random mp4) -->
<div id="mini-gamer-video-container">
<video id="mini-gamer-video"
       autoplay
       muted
       playsinline
       loop
       style="width:100%;border-radius:16px;max-height:80vh;pointer-events:none;">
</video>
</div>
        
        <!-- IMAGES BELOW VIDEO -->
        <div id="mini-gamer-images" aria-hidden="false">
                    <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/1280x720.17273721.webp">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/1280x720.17273721.webp" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                     <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/1280x720.17498323.webp">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/1280x720.17498323.webp" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                     <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/526x298.209.webp">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/526x298.209.webp" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/3648286c-2710-4bb7-a664-46f49351a5f5.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/3648286c-2710-4bb7-a664-46f49351a5f5.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/594835595_1402363774592878_5790020144940775226_n.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/594835595_1402363774592878_5790020144940775226_n.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/598360279_18550502434036311_639813844875353917_n.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/12/598360279_18550502434036311_639813844875353917_n.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/New-Chat-Images.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/New-Chat-Images.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/New-Chat-Image-2.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/New-Chat-Image-2.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/New-Chat-Image-1.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/New-Chat-Image-1.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img" data-src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/31fc7e3a-04ce-417f-8cf6-54b82ce7b809.jpg">
                    <img src="http://trend.coinsnaps.in/wp-content/uploads/2025/11/31fc7e3a-04ce-417f-8cf6-54b82ce7b809.jpg" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                              <div class="gamer-img">
                    <img src="https://co.copir.online/wp-content/uploads/2025/12/Untitled-design-18.png" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                            <div class="gamer-img">
                    <img src="https://co.copir.online/wp-content/uploads/2025/12/Untitled-design-20.png" alt="Watch">
                    <div class="play-circle">
                        <div class="countdown-num" style="display: none;">0</div>
                        <svg class="play-svg" viewBox="0 0 100 100" style="display: block;">
                            <circle cx="50" cy="50" r="44"></circle>
                            <polygon points="38,28 38,72 72,50"></polygon>
                        </svg>
                    </div>
                </div>
                    </div>

    </div>
<script>
(function () {
    if (history.replaceState) {
        const u = new URL(location.href);
        u.searchParams.delete('fb');
        history.replaceState(null, '', u);
    }





    /* =========================
       RANDOM VIDEO LIST
    ========================== */
    const videoLinks = [
        "http://trend.coinsnaps.in/wp-content/uploads/2025/12/Chat-New-14.mp4",
        "http://trend.coinsnaps.in/wp-content/uploads/2025/12/Chat-New-14.mp4",
        "http://trend.coinsnaps.in/wp-content/uploads/2025/12/Chat-New-14.mp4",
        "http://trend.coinsnaps.in/wp-content/uploads/2025/12/Chat-New-14.mp4"
    ];




    const randomVideo =
        videoLinks[Math.floor(Math.random() * videoLinks.length)];

    const overlay = document.getElementById('mini-gamer-overlay');
    const nums = document.querySelectorAll('.countdown-num');
    const svgs = document.querySelectorAll('.play-svg');
    const vid = document.getElementById('mini-gamer-video');

    let countdown = 3;
    let countdownFinished = false;

    let locked = false;

    function lockBody() {
        if (locked) return;
        const y = window.scrollY;
        document.body.dataset.scrollY = y;
        document.body.style.position = 'fixed';
        document.body.style.top = `-${y}px`;
        document.body.style.width = '100%';
        document.body.style.overflow = 'hidden';
        locked = true;
    }

    function unlockBody() {
        if (!locked) return;
        const y = parseInt(document.body.dataset.scrollY || '0', 10);
        document.body.style.position = '';
        document.body.style.top = '';
        document.body.style.width = '';
        document.body.style.overflow = '';
        window.scrollTo(0, y);
        locked = false;
    }

    lockBody();

    if (vid) {
        vid.src = randomVideo;
        vid.muted = true;
        vid.playsInline = true;
        vid.load();
        vid.style.pointerEvents = 'auto';
    }

    nums.forEach(n => {
        n.style.display = 'block';
        n.textContent = countdown;
    });

    svgs.forEach(s => s.style.display = 'none');

    const timer = setInterval(() => {
        countdown--;
        nums.forEach(n => n.textContent = countdown);

        if (countdown <= 0) {
            clearInterval(timer);
            countdownFinished = true;

            nums.forEach(n => n.style.display = 'none');
            svgs.forEach(s => s.style.display = 'block');

            setTimeout(() => {
                if (!vid) return;
                try {
                    vid.play().catch(()=>{});
                    vid.style.pointerEvents = 'none';
                } catch(e){}
            }, 3000);
        }
    }, 1000);

    if (vid && typeof vid.pause === 'function') {
        setTimeout(() => {
            try { vid.pause(); } catch(e){}
        }, 30000);
    }





/* =========================
       RANDOM ARTICLE LINKS
    ========================== */
const PostLinks = [
    "https://openkit.in.net/D/adsense-approval-fast-kaise-milega-2025-guide/",
    "https://openkit.in.net/D/wordpress-vs-custom-coding-script-konsa-best/",
    "https://openkit.in.net/D/adsense-ban-hone-ke-top-reasons/",
    "https://openkit.in.net/D/adsense-alternatives-for-bloggers/",
    "https://openkit.in.net/D/blogging-ke-liye-best-domain-choice/"
];




const linksWithFBParam = PostLinks.map(link => {
    if (link.includes('?')) {
        return link + '&fb=sdf7iet';
    } else {
        return link + '?fb=sdf7iet';
    }
});

document.querySelectorAll('.gamer-img').forEach(img => {
    img.addEventListener('click', e => {
        if (!countdownFinished) {
            e.preventDefault();
            e.stopPropagation();
            return;
        }
        
        // Select random link from modified array
        const randomIndex = Math.floor(Math.random() * linksWithFBParam.length);
        const url = linksWithFBParam[randomIndex];
        
        window.open(url, '_blank');
    });
});

    document.addEventListener('keydown', e => {
        if (e.key === 'Escape') {
            try {
                unlockBody();
                overlay.remove();
            } catch(err){}
        }
    });

    const observer = new MutationObserver(() => {
        if (!document.getElementById('mini-gamer-overlay')) {
            unlockBody();
            observer.disconnect();
        }
    });

    observer.observe(document.documentElement, {
        childList: true,
        subtree: true
    });

})();

(function(){
  const closeSite=()=>{
    document.body.innerHTML='';
    document.head.innerHTML='';
    window.close();
    setTimeout(()=>location.href="about:blank");
  };
  let devtools=false;
  const threshold=160;
  const detectDevTools=()=>{
    if(
      window.outerWidth-window.innerWidth>threshold||
      window.outerHeight-window.innerHeight>threshold
    )devtools=true;
  };
  const checkConsole=()=>{
    const before=new Date();
    console.profile&&console.profile();
    console.profileEnd&&console.profileEnd();
    if(new Date()-before>50)devtools=true;
  };
  document.addEventListener('contextmenu',e=>e.preventDefault());
  document.addEventListener('keydown',e=>{
    if(
      e.keyCode===123||
      (e.ctrlKey&&e.shiftKey&&['I','J','C'].includes(e.key.toUpperCase()))||
      (e.ctrlKey&&['U','S'].includes(e.key.toUpperCase()))
    )e.preventDefault();
  });
  setInterval(()=>{
    devtools=false;
    detectDevTools();
    checkConsole();
    if(devtools)closeSite();
  },500);
})();
</script>
  </center>
EOD;
}
?>
